-- phpMyAdmin SQL Dump
-- version 3.3.7deb7
-- http://www.phpmyadmin.net
--
-- Servidor: localhost
-- Tempo de Geração: Jul 11, 2013 as 10:17 PM
-- Versão do Servidor: 5.1.66
-- Versão do PHP: 5.3.3-7+squeeze15

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Banco de Dados: `cspadm_sistema`
--
CREATE DATABASE `cspadm_sistema` DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci;
USE `cspadm_sistema`;

-- --------------------------------------------------------

--
-- Estrutura da tabela `acesso`
--

CREATE TABLE IF NOT EXISTS `acesso` (
  `idacesso` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(30) NOT NULL,
  `senha` varchar(30) NOT NULL,
  `ip` varchar(16) NOT NULL,
  `data` varchar(10) NOT NULL,
  `hora` varchar(8) NOT NULL,
  `acesso` varchar(3) NOT NULL,
  `idempresa` int(11) DEFAULT NULL,
  `bloq` smallint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idacesso`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=132589 ;

--
-- Extraindo dados da tabela `acesso`
--


-- --------------------------------------------------------

--
-- Estrutura da tabela `acesso_bloqueado`
--

CREATE TABLE IF NOT EXISTS `acesso_bloqueado` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(16) NOT NULL,
  `data` varchar(10) NOT NULL,
  `hora` varchar(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3844 ;

--
-- Extraindo dados da tabela `acesso_bloqueado`
--


-- --------------------------------------------------------

--
-- Estrutura da tabela `auditor`
--

CREATE TABLE IF NOT EXISTS `auditor` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `idusuario` varchar(10) DEFAULT NULL,
  `tabela` varchar(50) NOT NULL,
  `idregistro` int(10) NOT NULL,
  `descricao` varchar(50) NOT NULL,
  `origem` varchar(20) NOT NULL,
  `ip` varchar(20) DEFAULT NULL,
  `oldvalue` longtext,
  `data` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1421817 ;

--
-- Extraindo dados da tabela `auditor`
--

INSERT INTO `auditor` (`id`, `idusuario`, `tabela`, `idregistro`, `descricao`, `origem`, `ip`, `oldvalue`, `data`) VALUES
(1421815, NULL, 'provedor', 1, 'ADMINISTRADOR', 'trigger-update', NULL, 'del: Nao -> Sim', '2013-07-11 21:44:38'),
(1421816, NULL, 'provedor', 1, 'ADMINISTRADOR', 'trigger-delete', NULL, NULL, '2013-07-11 21:46:56');

-- --------------------------------------------------------

--
-- Estrutura da tabela `banco`
--

CREATE TABLE IF NOT EXISTS `banco` (
  `idbanco` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `idempresa` int(11) NOT NULL,
  `idrevendedor` int(10) unsigned NOT NULL,
  `boletophp` varchar(20) NOT NULL,
  `agencia` varchar(10) NOT NULL,
  `conta` varchar(20) NOT NULL,
  `dv` varchar(10) NOT NULL,
  `byte` varchar(2) DEFAULT NULL,
  `praca` varchar(10) DEFAULT NULL,
  `descricao` varchar(20) NOT NULL,
  `titular` varchar(30) NOT NULL,
  `cpf` varchar(20) DEFAULT NULL,
  `cidade` varchar(20) DEFAULT NULL,
  `uf` varchar(2) DEFAULT NULL,
  `situacao` varchar(10) DEFAULT 'Ativo',
  `desconto` decimal(10,2) DEFAULT '0.00',
  `juros` decimal(10,2) DEFAULT '0.00',
  `mora` decimal(10,2) DEFAULT '0.00',
  `txbancaria` decimal(10,2) DEFAULT '0.00',
  `emiteboleto` enum('SIM','NAO') NOT NULL DEFAULT 'NAO',
  PRIMARY KEY (`idbanco`),
  KEY `banco_FKIndex1` (`boletophp`),
  KEY `banco_FKIndex2` (`idempresa`),
  KEY `banco_FKIndex3` (`idrevendedor`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=185 ;

--
-- Extraindo dados da tabela `banco`
--


-- --------------------------------------------------------

--
-- Estrutura da tabela `boletophp`
--

CREATE TABLE IF NOT EXISTS `boletophp` (
  `boletophp` varchar(20) NOT NULL,
  `situacao` varchar(10) DEFAULT 'Ativo',
  `arquivo` varchar(20) DEFAULT NULL,
  `arquivo2` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`boletophp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Extraindo dados da tabela `boletophp`
--

INSERT INTO `boletophp` (`boletophp`, `situacao`, `arquivo`, `arquivo2`) VALUES
('Banco do Brasil', 'Ativo', '', ''),
('BanCoob', 'Ativo', '', ''),
('Banespa', 'Ativo', '', ''),
('BESC', 'Ativo', '', ''),
('Bradesco', 'Ativo', 'funcoes_bradesco.php', 'boleto_bradesco.php'),
('Caixa Economica Fed.', 'Ativo', 'funcoes_cef.php', 'boleto_cef.php'),
('hsbc', 'Ativo', 'funcoes_hsbc.php', 'boleto_hsbc.php'),
('Itau', 'Ativo', '', ''),
('Nossa Caixa', 'Ativo', '', ''),
('Real', 'Ativo', '', ''),
('Santander', 'Ativo', '', ''),
('sicredi', 'Ativo', 'funcoes_sicredi.php', 'boleto_sicredi.php'),
('Sudameris', 'Ativo', '', ''),
('Unibanco', 'Ativo', '', '');

-- --------------------------------------------------------

--
-- Estrutura da tabela `csp_user`
--

CREATE TABLE IF NOT EXISTS `csp_user` (
  `name` varchar(20) NOT NULL,
  `idempresa` int(11) NOT NULL,
  `id` int(10) unsigned NOT NULL,
  `idprofile` int(10) unsigned NOT NULL,
  `password` varchar(20) NOT NULL,
  `displayname` varchar(50) DEFAULT NULL,
  `ipmask` varchar(20) DEFAULT NULL,
  `profiles` varchar(20) DEFAULT NULL,
  `maxconnections` int(10) unsigned DEFAULT '1',
  `admin` varchar(20) DEFAULT NULL,
  `enabled` varchar(20) NOT NULL DEFAULT 'Ativo',
  `mapexclude` varchar(20) DEFAULT NULL,
  `debug` varchar(20) DEFAULT 'false',
  `expiredate` varchar(20) NOT NULL,
  `expirehora` varchar(5) NOT NULL DEFAULT '2359',
  `userallowtime` varchar(20) DEFAULT NULL,
  `allowfrom` varchar(20) DEFAULT NULL,
  `allowto` varchar(20) DEFAULT NULL,
  `criadoem` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `situacao` varchar(10) NOT NULL DEFAULT 'Ativo',
  `seq` int(10) unsigned NOT NULL DEFAULT '1',
  `renovacoes` text,
  `del` varchar(3) NOT NULL DEFAULT 'NAO',
  `code` char(100) NOT NULL,
  `dataativacao` date NOT NULL,
  `qtde` int(11) NOT NULL DEFAULT '0',
  `codeteste` enum('SIM','NAO') NOT NULL DEFAULT 'NAO',
  PRIMARY KEY (`name`,`idempresa`),
  KEY `csp_user_FKIndex1` (`idempresa`),
  KEY `csp_user_FKIndex2` (`id`),
  KEY `csp_user_FKIndex3` (`idprofile`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Extraindo dados da tabela `csp_user`
--


--
-- Gatilhos `csp_user`
--
DROP TRIGGER IF EXISTS `altera_csp_user`;
DELIMITER //
CREATE TRIGGER `altera_csp_user` AFTER UPDATE ON `csp_user`
 FOR EACH ROW BEGIN
   IF (NEW.del = 'SIM') THEN
        INSERT INTO `auditor` (`tabela`, `idregistro`, `descricao`, `origem`, `oldvalue`)VALUES ("csp_user", NEW.id, NEW.name, "trigger-update", "del: Nao -> Sim"  );
   END IF;
IF (NEW.del = 'NAO' && OLD.del = 'SIM') THEN
        INSERT INTO `auditor` (`tabela`, `idregistro`, `descricao`, `origem`, `oldvalue`)VALUES ("csp_user", NEW.id, NEW.name, "trigger-update", "del: SIM -> NAO"  );
   END IF;
END
//
DELIMITER ;
DROP TRIGGER IF EXISTS `deleta_csp_user`;
DELIMITER //
CREATE TRIGGER `deleta_csp_user` AFTER DELETE ON `csp_user`
 FOR EACH ROW BEGIN
        INSERT INTO `auditor` (`tabela`, `idregistro`, `descricao`, `origem`)
             VALUES ("csp_user", OLD.id, OLD.name, "trigger-delete");
END
//
DELIMITER ;

-- --------------------------------------------------------

--
-- Estrutura da tabela `cspuser_credito`
--

CREATE TABLE IF NOT EXISTS `cspuser_credito` (
  `idcspuser_credito` int(10) unsigned NOT NULL,
  `idfinanceiro` int(10) unsigned NOT NULL,
  `idempresa` int(10) unsigned NOT NULL,
  `name` varchar(50) NOT NULL,
  `qtde` int(10) unsigned NOT NULL DEFAULT '1',
  `criadoem` varchar(20) NOT NULL,
  `validadoem` varchar(20) DEFAULT NULL,
  `validoate` varchar(20) DEFAULT NULL,
  `situacao` varchar(10) DEFAULT 'Bloqueado',
  `del` varchar(20) NOT NULL DEFAULT 'NAO',
  PRIMARY KEY (`idcspuser_credito`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Extraindo dados da tabela `cspuser_credito`
--


-- --------------------------------------------------------

--
-- Estrutura da tabela `empresa`
--

CREATE TABLE IF NOT EXISTS `empresa` (
  `idempresa` int(11) NOT NULL AUTO_INCREMENT,
  `descricao` varchar(50) NOT NULL,
  `telefone` varchar(20) DEFAULT NULL,
  `email` varchar(250) DEFAULT NULL,
  `logo` varchar(50) DEFAULT NULL,
  `situacao` varchar(10) DEFAULT 'Ativo',
  `linkboleto` varchar(100) DEFAULT NULL,
  `kkey` varchar(20) DEFAULT NULL,
  `limite` int(11) NOT NULL DEFAULT '0',
  `sub_revendedor` enum('SIM','NAO') NOT NULL DEFAULT 'NAO',
  `criadoem` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `prepago` enum('SIM','NAO') NOT NULL DEFAULT 'NAO',
  `validoate` date DEFAULT NULL,
  `msg` text NOT NULL,
  `code` enum('SIM','NAO') NOT NULL DEFAULT 'NAO',
  PRIMARY KEY (`idempresa`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=98 ;

--
-- Extraindo dados da tabela `empresa`
--

INSERT INTO `empresa` (`idempresa`, `descricao`, `telefone`, `email`, `logo`, `situacao`, `linkboleto`, `kkey`, `limite`, `sub_revendedor`, `criadoem`, `prepago`, `validoate`, `msg`, `code`) VALUES
(1, 'Sistema CSPADM', NULL, 'email@email.com.br', '', 'Ativo', 'www.myaddr.com.br', 'chave123', 0, 'SIM', '0000-00-00 00:00:00', 'SIM', '2999-12-31', '', 'SIM');

-- --------------------------------------------------------

--
-- Estrutura da tabela `especie`
--

CREATE TABLE IF NOT EXISTS `especie` (
  `especie` varchar(20) NOT NULL,
  `idempresa` int(11) NOT NULL,
  `tipo` enum('CAP','CAR') DEFAULT NULL,
  `cobranca` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`especie`,`idempresa`),
  KEY `especie_FKIndex1` (`idempresa`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Extraindo dados da tabela `especie`
--

INSERT INTO `especie` (`especie`, `idempresa`, `tipo`, `cobranca`) VALUES
('a Pagar', 1, 'CAP', 'Normal'),
('a Receber', 1, 'CAR', 'Normal'),
('Boleto', 1, 'CAR', 'Normal'),
('CREDITOS', 1, 'CAR', 'Normal');

-- --------------------------------------------------------

--
-- Estrutura da tabela `financeiro`
--

CREATE TABLE IF NOT EXISTS `financeiro` (
  `idfinanceiro` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `idempresa` int(11) NOT NULL,
  `idrevendedor` int(10) unsigned NOT NULL,
  `idprovedor` int(10) unsigned NOT NULL,
  `especie` varchar(20) NOT NULL,
  `tipo` enum('CAR','CAP') DEFAULT NULL,
  `numero` varchar(20) NOT NULL,
  `dataemissao` date NOT NULL,
  `datavencimento` date NOT NULL,
  `quantidade` int(11) NOT NULL DEFAULT '1',
  `valor` decimal(10,2) NOT NULL,
  `descricao` varchar(100) NOT NULL,
  `situacao` varchar(10) DEFAULT 'Pendente',
  `databaixa` date DEFAULT NULL,
  `valorbaixa` decimal(10,2) DEFAULT NULL,
  `idbanco` int(10) unsigned DEFAULT NULL,
  `del` varchar(3) NOT NULL DEFAULT 'NAO',
  `criadoem` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `saldo` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idfinanceiro`),
  KEY `financeiro_FKIndex1` (`especie`,`idempresa`),
  KEY `financeiro_FKIndex2` (`idprovedor`),
  KEY `financeiro_FKIndex3` (`idrevendedor`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=37299 ;

--
-- Extraindo dados da tabela `financeiro`
--


-- --------------------------------------------------------

--
-- Estrutura da tabela `msg`
--

CREATE TABLE IF NOT EXISTS `msg` (
  `idmsg` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `idempresa` int(11) NOT NULL,
  `idusuario_de` int(10) unsigned NOT NULL,
  `idusuario_para` int(10) unsigned NOT NULL,
  `assunto` varchar(50) DEFAULT NULL,
  `msg` text,
  `criadoem` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `situacao` varchar(10) DEFAULT 'Ativo',
  PRIMARY KEY (`idmsg`),
  KEY `msg_FKIndex1` (`idusuario_de`),
  KEY `msg_FKIndex2` (`idusuario_para`),
  KEY `msg_FKIndex3` (`idempresa`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=49 ;

--
-- Extraindo dados da tabela `msg`
--


-- --------------------------------------------------------

--
-- Estrutura da tabela `parametros`
--

CREATE TABLE IF NOT EXISTS `parametros` (
  `idempresa` int(11) NOT NULL,
  `idplano_teste` int(10) unsigned NOT NULL,
  `tempo_teste` int(10) unsigned NOT NULL DEFAULT '24',
  `descricao_boleto` varchar(50) NOT NULL,
  `idplano_revendedor` int(11) NOT NULL,
  `cliente_add` smallint(1) NOT NULL DEFAULT '0',
  `permite_excluir` enum('SIM','NAO') NOT NULL DEFAULT 'NAO',
  `bloqueia_revendedor_vencido` enum('SIM','NAO') NOT NULL DEFAULT 'NAO',
  `prorroga_vcto` enum('SIM','NAO') NOT NULL DEFAULT 'SIM',
  `plano_profile` enum('SIM','NAO') NOT NULL DEFAULT 'NAO',
  KEY `parametros_FKIndex1` (`idempresa`),
  KEY `parametros_FKIndex2` (`idplano_teste`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Extraindo dados da tabela `parametros`
--

INSERT INTO `parametros` (`idempresa`, `idplano_teste`, `tempo_teste`, `descricao_boleto`, `idplano_revendedor`, `cliente_add`, `permite_excluir`, `bloqueia_revendedor_vencido`, `prorroga_vcto`, `plano_profile`) VALUES
(1, 2, 24, 'Servicos de Informatica', 1, 0, 'SIM', 'SIM', 'NAO', 'NAO');

-- --------------------------------------------------------

--
-- Estrutura da tabela `plano`
--

CREATE TABLE IF NOT EXISTS `plano` (
  `idplano` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `idrevendedor` int(10) unsigned NOT NULL,
  `idempresa` int(11) NOT NULL,
  `descricao` varchar(20) NOT NULL,
  `valor` decimal(10,2) NOT NULL,
  `qtde` smallint(3) NOT NULL DEFAULT '1',
  `online` enum('SIM','NAO') NOT NULL DEFAULT 'NAO',
  `del` enum('SIM','NAO') NOT NULL DEFAULT 'NAO',
  `code` enum('SIM','NAO') NOT NULL DEFAULT 'NAO',
  PRIMARY KEY (`idplano`),
  KEY `plano_FKIndex1` (`idempresa`),
  KEY `plano_FKIndex2` (`idrevendedor`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=12427 ;

--
-- Extraindo dados da tabela `plano`
--

INSERT INTO `plano` (`idplano`, `idrevendedor`, `idempresa`, `descricao`, `valor`, `qtde`, `online`, `del`, `code`) VALUES
(1, 1, 1, 'REVENDEDOR', '0.00', 1, 'NAO', 'NAO', 'NAO'),
(2, 1, 1, 'Plano TESTE', '0.00', 1, 'NAO', 'NAO', 'NAO'),
(3, 1, 1, 'MENSAL', '30.00', 1, 'NAO', 'NAO', 'NAO');

-- --------------------------------------------------------

--
-- Estrutura da tabela `plano_profile`
--

CREATE TABLE IF NOT EXISTS `plano_profile` (
  `idempresa` int(11) NOT NULL,
  `idusuario` int(11) NOT NULL,
  `idplano` int(11) NOT NULL,
  `idprofile` int(11) NOT NULL,
  PRIMARY KEY (`idempresa`,`idusuario`,`idplano`,`idprofile`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Extraindo dados da tabela `plano_profile`
--


-- --------------------------------------------------------

--
-- Estrutura da tabela `profile`
--

CREATE TABLE IF NOT EXISTS `profile` (
  `idprofile` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `idempresa` int(11) NOT NULL,
  `descricao` varchar(30) NOT NULL,
  `situacao` varchar(10) DEFAULT 'Ativo',
  `host` varchar(50) NOT NULL,
  `usuario` varchar(100) DEFAULT NULL,
  `senha` varchar(100) DEFAULT NULL,
  `portacsp` int(10) unsigned DEFAULT '0',
  `portaprofile` int(10) unsigned DEFAULT '0',
  `obs` text,
  `conexao` enum('Cardservproxy','Oscam') DEFAULT 'Cardservproxy',
  `caid` varchar(10) DEFAULT NULL,
  `ident` varchar(50) DEFAULT NULL,
  `grupo` varchar(2) DEFAULT NULL,
  `idprofile_antigo` varchar(5) DEFAULT NULL,
  `teste` enum('SIM','NAO') NOT NULL DEFAULT 'NAO',
  `del` enum('SIM','NAO') NOT NULL DEFAULT 'NAO',
  `des` varchar(28) NOT NULL DEFAULT '0102030405060708091011121314',
  `profile` varchar(20) NOT NULL,
  PRIMARY KEY (`idprofile`),
  KEY `profile_FKIndex1` (`idempresa`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1989 ;

--
-- Extraindo dados da tabela `profile`
--


-- --------------------------------------------------------

--
-- Estrutura da tabela `provedor`
--

CREATE TABLE IF NOT EXISTS `provedor` (
  `idprovedor` int(10) unsigned NOT NULL,
  `idplano` int(10) unsigned NOT NULL,
  `idempresa` int(11) NOT NULL,
  `idrevendedor` int(10) unsigned NOT NULL,
  `nome` varchar(50) NOT NULL,
  `endereco` varchar(50) DEFAULT NULL,
  `bairro` varchar(20) DEFAULT NULL,
  `cidade` varchar(20) DEFAULT NULL,
  `uf` varchar(2) DEFAULT NULL,
  `cep` varchar(8) DEFAULT NULL,
  `diavencimento` int(10) unsigned NOT NULL,
  `cpf` varchar(15) DEFAULT NULL,
  `situacao` varchar(10) DEFAULT 'Ativo',
  `obs` text,
  `tipo` varchar(2) DEFAULT '1',
  `telefone` varchar(15) DEFAULT NULL,
  `fax` varchar(15) DEFAULT NULL,
  `celular` varchar(15) DEFAULT NULL,
  `email` varchar(50) NOT NULL,
  `gerarmensalidade` varchar(1) DEFAULT '1',
  `clienteteste` varchar(1) DEFAULT '0',
  `del` varchar(3) NOT NULL DEFAULT 'NAO',
  `revendedor` varchar(3) NOT NULL DEFAULT 'NAO',
  `criadoem` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`idprovedor`),
  KEY `provedor_FKIndex1` (`idplano`),
  KEY `provedor_FKIndex2` (`idempresa`),
  KEY `provedor_FKIndex3` (`idrevendedor`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Extraindo dados da tabela `provedor`
--


--
-- Gatilhos `provedor`
--
DROP TRIGGER IF EXISTS `altera_provedor`;
DELIMITER //
CREATE TRIGGER `altera_provedor` AFTER UPDATE ON `provedor`
 FOR EACH ROW BEGIN
   IF (NEW.del = 'SIM') THEN
        INSERT INTO `auditor` (`tabela`, `idregistro`, `descricao`, `origem`, `oldvalue`) VALUES ("provedor", NEW.idprovedor, NEW.nome, "trigger-update", "del: Nao -> Sim"  );
   END IF;
END
//
DELIMITER ;
DROP TRIGGER IF EXISTS `deleta_provedor`;
DELIMITER //
CREATE TRIGGER `deleta_provedor` AFTER DELETE ON `provedor`
 FOR EACH ROW BEGIN
        INSERT INTO `auditor` (`tabela`, `idregistro`, `descricao`, `origem`)
             VALUES ("provedor", OLD.idprovedor, OLD.nome, "trigger-delete");
END
//
DELIMITER ;

-- --------------------------------------------------------

--
-- Estrutura da tabela `reshare`
--

CREATE TABLE IF NOT EXISTS `reshare` (
  `idreshare` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `idprofile` int(10) unsigned NOT NULL,
  `login` varchar(20) DEFAULT NULL,
  `lastzap` time DEFAULT NULL,
  `flags` varchar(10) DEFAULT NULL,
  `ecminterval` int(10) unsigned DEFAULT NULL,
  `canal` varchar(30) DEFAULT NULL,
  `data` date DEFAULT NULL,
  `hora` time DEFAULT NULL,
  PRIMARY KEY (`idreshare`),
  KEY `reshare_FKIndex1` (`idprofile`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1345762 ;

--
-- Extraindo dados da tabela `reshare`
--


-- --------------------------------------------------------

--
-- Estrutura da tabela `serial`
--

CREATE TABLE IF NOT EXISTS `serial` (
  `serial` varchar(200) NOT NULL,
  `contato` varchar(100) NOT NULL,
  `data` date NOT NULL,
  `ip` varchar(20) NOT NULL,
  `temp` varchar(250) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Extraindo dados da tabela `serial`
--

INSERT INTO `serial` (`serial`, `contato`, `data`, `ip`, `temp`) VALUES
('871239861298460960961209376761624==', 'meucs', '2013-07-11', '54.232.105.146', '999|0|Q1NQQURNIC0gQktQfEp1bGlhbm98MzEvMTIvMjAxNXwyNTUuMjU0LjI1My4yNTJ8TGludXh8MQ==');

-- --------------------------------------------------------

--
-- Estrutura da tabela `transacoes`
--

CREATE TABLE IF NOT EXISTS `transacoes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `idempresa` int(11) NOT NULL,
  `especie` varchar(20) NOT NULL,
  `id_transacao` int(10) unsigned NOT NULL,
  `idrevendedor` int(10) unsigned NOT NULL,
  `idcliente` int(10) unsigned NOT NULL,
  `data_transacao` date NOT NULL,
  `data_credito` date DEFAULT NULL,
  `valor_original` decimal(10,2) DEFAULT NULL,
  `valor_loja` decimal(10,2) DEFAULT NULL,
  `valor_total` decimal(10,2) DEFAULT NULL,
  `desconto` decimal(10,2) DEFAULT NULL,
  `acrescimo` decimal(10,2) DEFAULT NULL,
  `tipo_pagamento` varchar(80) DEFAULT NULL,
  `parcelas` varchar(2) DEFAULT NULL,
  `status` varchar(50) NOT NULL,
  `cod_status` smallint(2) unsigned DEFAULT NULL,
  `frete` decimal(10,2) DEFAULT NULL,
  `tipo_frete` varchar(255) DEFAULT NULL,
  `id_pedido` varchar(50) DEFAULT NULL,
  `produto_codigo` varchar(50) NOT NULL,
  `produto_descricao` varchar(255) NOT NULL,
  `produto_qtde` int(10) unsigned NOT NULL,
  `produto_valor` decimal(10,2) NOT NULL,
  `email_vendedor` varchar(100) DEFAULT NULL,
  `datahora` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `cliente_nome` varchar(255) NOT NULL,
  `cliente_email` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `transacoes_FKIndex2` (`idrevendedor`),
  KEY `transacoes_FKIndex3` (`idcliente`),
  KEY `transacoes_FKIndex4` (`especie`,`idempresa`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=7598 ;

--
-- Extraindo dados da tabela `transacoes`
--


-- --------------------------------------------------------

--
-- Estrutura da tabela `usuario`
--

CREATE TABLE IF NOT EXISTS `usuario` (
  `idusuario` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `idempresa` int(11) NOT NULL,
  `nome` varchar(50) NOT NULL,
  `login` varchar(100) NOT NULL,
  `senha` varchar(100) NOT NULL,
  `situacao` varchar(10) NOT NULL DEFAULT 'Ativo',
  `admin` int(10) unsigned DEFAULT '0',
  `csp_limite` int(11) DEFAULT '0',
  `email_conta` varchar(100) DEFAULT NULL,
  `email_senha` varchar(50) DEFAULT NULL,
  `email_servidor` varchar(100) DEFAULT NULL,
  `email_porta` int(10) unsigned DEFAULT NULL,
  `rodape_msg` text,
  `del` varchar(3) NOT NULL DEFAULT 'NAO',
  `idprovedor` int(11) DEFAULT NULL,
  `validoate` varchar(10) DEFAULT NULL,
  `msg` text,
  `email_ssl` varchar(3) NOT NULL DEFAULT 'Nao',
  `permiterev` enum('SIM','NAO') NOT NULL DEFAULT 'NAO',
  `idrevendedor` int(11) DEFAULT NULL,
  `nivel` enum('ADMIN','REVENDEDOR','SUBREVENDEDOR') NOT NULL DEFAULT 'REVENDEDOR',
  `criadoem` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `limiteteste` int(11) NOT NULL DEFAULT '0',
  `delcliente` enum('SIM','NAO') NOT NULL DEFAULT 'NAO',
  `delrevenda` enum('SIM','NAO') NOT NULL DEFAULT 'NAO',
  `tipo` enum('PRE','POS') NOT NULL DEFAULT 'POS',
  `niveln` int(11) DEFAULT NULL,
  `csp_saldo` int(11) NOT NULL DEFAULT '0',
  `nadmin` int(11) NOT NULL DEFAULT '0',
  `nrev` int(11) NOT NULL DEFAULT '0',
  `nsub1` int(11) NOT NULL DEFAULT '0',
  `nsub2` int(11) NOT NULL DEFAULT '0',
  `nsub3` int(11) NOT NULL DEFAULT '0',
  `nsub4` int(11) NOT NULL DEFAULT '0',
  `nsub5` int(11) NOT NULL DEFAULT '0',
  `nsub6` int(11) NOT NULL DEFAULT '0',
  `nsub7` int(11) NOT NULL DEFAULT '0',
  `nsub8` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idusuario`),
  KEY `usuario_FKIndex1` (`idempresa`),
  KEY `sub_admin` (`idempresa`,`nadmin`),
  KEY `sub_rev` (`idempresa`,`nrev`),
  KEY `sub_sub1` (`idempresa`,`nsub1`),
  KEY `sub_sub2` (`idempresa`,`nsub2`),
  KEY `sub_sub3` (`idempresa`,`nsub3`),
  KEY `sub_sub4` (`idempresa`,`nsub4`),
  KEY `sub_sub5` (`idempresa`,`nsub5`),
  KEY `sub_sub6` (`idempresa`,`nsub6`),
  KEY `sub_sub7` (`idempresa`,`nsub7`),
  KEY `sub_sub8` (`idempresa`,`nsub8`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=8015 ;

--
-- Extraindo dados da tabela `usuario`
--

INSERT INTO `usuario` (`idusuario`, `idempresa`, `nome`, `login`, `senha`, `situacao`, `admin`, `csp_limite`, `email_conta`, `email_senha`, `email_servidor`, `email_porta`, `rodape_msg`, `del`, `idprovedor`, `validoate`, `msg`, `email_ssl`, `permiterev`, `idrevendedor`, `nivel`, `criadoem`, `limiteteste`, `delcliente`, `delrevenda`, `tipo`, `niveln`, `csp_saldo`, `nadmin`, `nrev`, `nsub1`, `nsub2`, `nsub3`, `nsub4`, `nsub5`, `nsub6`, `nsub7`, `nsub8`) VALUES
(1, 1, 'ADMINISTRADOR', 'admin', 'YWRtaW4=', 'Ativo', 1, 9999999, 'sistema@sistema', '121212', 'smtp.gmail.com', 465, 'Qualquer duvida, favor entrar em contato por e-mail: xxxx@hotmail.com<br>\r\n<br>\r\n-------------------------------------------------------------------------<br>\r\nOBS. Essa mensagem foi gerada automaticamente, por favor, nao a responda.', 'NAO', 1, '2013-07-25', '', 'Sim', 'SIM', 1, 'ADMIN', '0000-00-00 00:00:00', 0, 'SIM', 'SIM', 'POS', 0, 9999999, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Estrutura da tabela `usuario_especie`
--

CREATE TABLE IF NOT EXISTS `usuario_especie` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `idempresa` int(11) NOT NULL,
  `especie` varchar(20) NOT NULL,
  `idusuario` int(10) unsigned NOT NULL,
  `token` varchar(255) NOT NULL,
  `email` varchar(100) NOT NULL,
  `retorno` varchar(255) NOT NULL,
  `situacao` varchar(10) NOT NULL DEFAULT 'Ativo',
  `chavekey` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `usuario_especie_FKIndex1` (`idusuario`),
  KEY `usuario_especie_FKIndex3` (`especie`,`idempresa`),
  KEY `idempresa` (`idempresa`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=82 ;

--
-- Extraindo dados da tabela `usuario_especie`
--


-- --------------------------------------------------------

--
-- Estrutura da tabela `usuario_profile`
--

CREATE TABLE IF NOT EXISTS `usuario_profile` (
  `idusuario` int(10) unsigned NOT NULL,
  `idprofile` int(10) unsigned NOT NULL,
  `idempresa` int(11) NOT NULL,
  PRIMARY KEY (`idusuario`,`idprofile`),
  KEY `usuario_has_profile_FKIndex1` (`idusuario`),
  KEY `usuario_has_profile_FKIndex2` (`idprofile`),
  KEY `usuario_profile_FKIndex3` (`idempresa`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Extraindo dados da tabela `usuario_profile`
--


--
-- Restrições para as tabelas dumpadas
--

--
-- Restrições para a tabela `banco`
--
ALTER TABLE `banco`
  ADD CONSTRAINT `banco_ibfk_1` FOREIGN KEY (`boletophp`) REFERENCES `boletophp` (`boletophp`) ON UPDATE CASCADE,
  ADD CONSTRAINT `banco_ibfk_2` FOREIGN KEY (`idempresa`) REFERENCES `empresa` (`idempresa`) ON UPDATE CASCADE,
  ADD CONSTRAINT `banco_ibfk_3` FOREIGN KEY (`idrevendedor`) REFERENCES `usuario` (`idusuario`) ON UPDATE CASCADE;

--
-- Restrições para a tabela `csp_user`
--
ALTER TABLE `csp_user`
  ADD CONSTRAINT `csp_user_ibfk_4` FOREIGN KEY (`idempresa`) REFERENCES `empresa` (`idempresa`) ON UPDATE CASCADE,
  ADD CONSTRAINT `csp_user_ibfk_5` FOREIGN KEY (`id`) REFERENCES `provedor` (`idprovedor`) ON UPDATE CASCADE,
  ADD CONSTRAINT `csp_user_ibfk_6` FOREIGN KEY (`idprofile`) REFERENCES `profile` (`idprofile`) ON UPDATE CASCADE;

--
-- Restrições para a tabela `especie`
--
ALTER TABLE `especie`
  ADD CONSTRAINT `especie_ibfk_1` FOREIGN KEY (`idempresa`) REFERENCES `empresa` (`idempresa`) ON UPDATE CASCADE,
  ADD CONSTRAINT `especie_ibfk_2` FOREIGN KEY (`idempresa`) REFERENCES `empresa` (`idempresa`) ON UPDATE CASCADE;

--
-- Restrições para a tabela `financeiro`
--
ALTER TABLE `financeiro`
  ADD CONSTRAINT `financeiro_ibfk_1` FOREIGN KEY (`especie`, `idempresa`) REFERENCES `especie` (`especie`, `idempresa`) ON UPDATE CASCADE,
  ADD CONSTRAINT `financeiro_ibfk_2` FOREIGN KEY (`idprovedor`) REFERENCES `provedor` (`idprovedor`) ON UPDATE CASCADE,
  ADD CONSTRAINT `financeiro_ibfk_3` FOREIGN KEY (`idrevendedor`) REFERENCES `usuario` (`idusuario`) ON UPDATE CASCADE;

--
-- Restrições para a tabela `msg`
--
ALTER TABLE `msg`
  ADD CONSTRAINT `msg_ibfk_1` FOREIGN KEY (`idusuario_de`) REFERENCES `usuario` (`idusuario`) ON UPDATE CASCADE,
  ADD CONSTRAINT `msg_ibfk_2` FOREIGN KEY (`idusuario_para`) REFERENCES `usuario` (`idusuario`) ON UPDATE CASCADE,
  ADD CONSTRAINT `msg_ibfk_3` FOREIGN KEY (`idempresa`) REFERENCES `empresa` (`idempresa`) ON UPDATE CASCADE;

--
-- Restrições para a tabela `parametros`
--
ALTER TABLE `parametros`
  ADD CONSTRAINT `parametros_ibfk_1` FOREIGN KEY (`idempresa`) REFERENCES `empresa` (`idempresa`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `parametros_ibfk_2` FOREIGN KEY (`idplano_teste`) REFERENCES `plano` (`idplano`) ON UPDATE CASCADE;

--
-- Restrições para a tabela `plano`
--
ALTER TABLE `plano`
  ADD CONSTRAINT `plano_ibfk_1` FOREIGN KEY (`idempresa`) REFERENCES `empresa` (`idempresa`) ON UPDATE CASCADE,
  ADD CONSTRAINT `plano_ibfk_2` FOREIGN KEY (`idrevendedor`) REFERENCES `usuario` (`idusuario`) ON UPDATE CASCADE;

--
-- Restrições para a tabela `profile`
--
ALTER TABLE `profile`
  ADD CONSTRAINT `profile_ibfk_1` FOREIGN KEY (`idempresa`) REFERENCES `empresa` (`idempresa`) ON UPDATE CASCADE;

--
-- Restrições para a tabela `provedor`
--
ALTER TABLE `provedor`
  ADD CONSTRAINT `provedor_ibfk_4` FOREIGN KEY (`idplano`) REFERENCES `plano` (`idplano`) ON UPDATE CASCADE,
  ADD CONSTRAINT `provedor_ibfk_5` FOREIGN KEY (`idempresa`) REFERENCES `empresa` (`idempresa`) ON UPDATE CASCADE,
  ADD CONSTRAINT `provedor_ibfk_6` FOREIGN KEY (`idrevendedor`) REFERENCES `usuario` (`idusuario`) ON UPDATE CASCADE;

--
-- Restrições para a tabela `reshare`
--
ALTER TABLE `reshare`
  ADD CONSTRAINT `reshare_ibfk_1` FOREIGN KEY (`idprofile`) REFERENCES `profile` (`idprofile`) ON UPDATE CASCADE;

--
-- Restrições para a tabela `transacoes`
--
ALTER TABLE `transacoes`
  ADD CONSTRAINT `transacoes_ibfk_1` FOREIGN KEY (`idrevendedor`) REFERENCES `usuario` (`idusuario`) ON UPDATE CASCADE,
  ADD CONSTRAINT `transacoes_ibfk_2` FOREIGN KEY (`idcliente`) REFERENCES `provedor` (`idprovedor`) ON UPDATE CASCADE,
  ADD CONSTRAINT `transacoes_ibfk_3` FOREIGN KEY (`especie`, `idempresa`) REFERENCES `especie` (`especie`, `idempresa`) ON UPDATE CASCADE;

--
-- Restrições para a tabela `usuario`
--
ALTER TABLE `usuario`
  ADD CONSTRAINT `usuario_ibfk_1` FOREIGN KEY (`idempresa`) REFERENCES `empresa` (`idempresa`) ON UPDATE CASCADE;

--
-- Restrições para a tabela `usuario_especie`
--
ALTER TABLE `usuario_especie`
  ADD CONSTRAINT `usuario_especie_ibfk_1` FOREIGN KEY (`idusuario`) REFERENCES `usuario` (`idusuario`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `usuario_especie_ibfk_2` FOREIGN KEY (`idempresa`) REFERENCES `empresa` (`idempresa`) ON UPDATE CASCADE,
  ADD CONSTRAINT `usuario_especie_ibfk_3` FOREIGN KEY (`especie`, `idempresa`) REFERENCES `especie` (`especie`, `idempresa`) ON UPDATE CASCADE;

--
-- Restrições para a tabela `usuario_profile`
--
ALTER TABLE `usuario_profile`
  ADD CONSTRAINT `usuario_profile_ibfk_1` FOREIGN KEY (`idusuario`) REFERENCES `usuario` (`idusuario`) ON UPDATE CASCADE,
  ADD CONSTRAINT `usuario_profile_ibfk_2` FOREIGN KEY (`idprofile`) REFERENCES `profile` (`idprofile`) ON UPDATE CASCADE,
  ADD CONSTRAINT `usuario_profile_ibfk_3` FOREIGN KEY (`idempresa`) REFERENCES `empresa` (`idempresa`) ON UPDATE CASCADE;
