<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class Transacao_Model extends MY_Model {

    private $tabela = 'cmum_transacoes';
    public $paginacao;
    public $ultimo_id_inserido;
    

    function __construct() {
        parent::__construct();

        $this->paginacao = new stdClass();
        $this->paginacao->por_pagina = 10;
    }

    function save($dados = null) {
        /*
          id	int(11)	Não
          id_user	int(11)	Não // sessao
          id_revenda	int(11)	Não // sessao
          tipo	int(11)	Não /1-pagseguro,2-Boleto Facil 3-deposito
          valor_un	decimal(10,0)	Não
          qtd_meses	int(11)	Não
          valor_total	decimal(10,0)	Não
          data_cad	datetime	Não
          data_atualizacao	datetime	Não
          status	int(11)	Não 0-aberto, 1-aguardando pagamento, 3-aprovado , 4-fechado
         */

        if (null === $dados) {
            exit();
        }

        $retorno = $this->db->insert($this->tabela, $this->_antiSqlInject($dados));
        
        $this->ultimo_id_inserido = $this->db->insert_id();
        
        return $retorno;        
        
    }

    function getAll() {
        $rs = $this->db->query(sprintf("SELECT t.*,u.name AS login,ta.id AS id_arquivo,ta.nome_arquivo_salvo,ta.nome_arquivo_orig,ta.caminho_completo_arquivo,r.username AS revenda FROM %s AS t "
                        . "INNER JOIN %s AS u ON t.id_user = u.id "
                        . "LEFT JOIN %s AS ta ON t.id = ta.id_transacao "
                        . "INNER JOIN %s AS r ON t.id_revenda = r.id", $this->tabela, 'cmum_udb', 'cmum_transacao_arquivo', 'cmum_admins'));
        if ($rs->num_rows()) {
            return $rs->result_array();
        }
        return false;
    }

    function getAllByLogin($id_login = null, $limite_inicio = 0) {
        
        // retorna o total de dados
        $rs_total = $this->db->query(sprintf("SELECT t.*,u.name AS login,ta.id AS id_arquivo,ta.nome_arquivo_salvo,ta.nome_arquivo_orig,ta.caminho_completo_arquivo,r.username AS revenda FROM %s AS t "
                        . "INNER JOIN %s AS u ON t.id_user = u.id "
                        . "LEFT JOIN %s AS ta ON t.id = ta.id_transacao "
                        . "INNER JOIN %s AS r ON t.id_revenda = r.id "
                        . "WHERE t.id_user = %d", $this->tabela, 'cmum_udb', 'cmum_transacao_arquivo', 'cmum_admins', $this->_antiSqlInject($id_login)));
        if ($rs_total->num_rows()) {
            $this->paginacao->total_rows = $rs_total->num_rows();            
        }
        
        // retorna um array de dados
        $rs_dados = $this->db->query(sprintf("SELECT t.*,u.name AS login,ta.id AS id_arquivo,ta.nome_arquivo_salvo,ta.nome_arquivo_orig,ta.caminho_completo_arquivo,r.username AS revenda FROM %s AS t "
                        . "INNER JOIN %s AS u ON t.id_user = u.id "
                        . "LEFT JOIN %s AS ta ON t.id = ta.id_transacao "
                        . "INNER JOIN %s AS r ON t.id_revenda = r.id "
                        . "WHERE t.id_user = %d ORDER BY t.id DESC LIMIT %d,%d ", $this->tabela, 'cmum_udb', 'cmum_transacao_arquivo', 'cmum_admins', $this->_antiSqlInject($id_login),(($limite_inicio - 1) * $this->paginacao->por_pagina), $this->paginacao->por_pagina)); 
        
        if ($rs_dados->num_rows()) {
            $this->paginacao->dados = $rs_dados->result_array();            
        }
        return false;
    }

    function getAllByRevenda($id_revenda = null) {
        $rs = $this->db->query(sprintf("SELECT t.*,u.name AS login,ta.id AS id_arquivo,ta.nome_arquivo_salvo,ta.nome_arquivo_orig,ta.caminho_completo_arquivo,r.username AS revenda FROM %s AS t "
                        . "INNER JOIN %s AS u ON t.id_user = u.id "
                        . "LEFT JOIN %s AS ta ON t.id = ta.id_transacao "
                        . "INNER JOIN %s AS r ON t.id_revenda = r.id "
                        . "WHERE t.id_revenda = %d", $this->tabela, 'cmum_udb', 'cmum_transacao_arquivo', 'cmum_admins', $this->_antiSqlInject($id_revenda)));
        if ($rs->num_rows()) {
            return $rs->result_array();
        }
        return false;
    }

}
